@extends('layouts.admin')

@section('content')
    <!-- Page Header -->
    <div class="py-6 bg-[#F6F6F6] border-b border-[#CBB4B0]">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold text-gray-900">Manajemen Partner</h1>
                    <p class="text-gray-600 mt-1">Kelola data partner/rekanan klinik</p>
                </div>
                <div class="flex items-center space-x-4">
                    <a href="{{ route('admin.partners.create') }}" 
                       class="inline-flex items-center px-4 py-2 bg-[#192D50] border border-transparent rounded-none font-semibold text-xs text-white uppercase tracking-widest hover:bg-[#8B8B8B] focus:bg-[#8B8B8B] active:bg-[#192D50] focus:outline-none focus:ring-2 focus:ring-[#CBB4B0] focus:ring-offset-2 transition ease-in-out duration-150">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                        Tambah Partner
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Search and Filter -->
    <div class="py-8 bg-[#F6F6F6]">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none mb-8 border border-[#CBB4B0]">
                <div class="p-6">
                    <form method="GET" action="{{ route('admin.partners.index') }}" class="space-y-4">
                        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                            <!-- Search Input -->
                            <div>
                                <label for="search" class="block text-sm font-medium text-gray-700 mb-2">Cari</label>
                                <input type="text" id="search" name="search" 
                                       value="{{ request('search') }}"
                                       placeholder="Cari berdasarkan nama, kode, email, contact person..."
                                       class="w-full px-3 py-2 border border-gray-300 rounded-none focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                            </div>
                            
                            <!-- Status Filter -->
                            <div>
                                <label for="status" class="block text-sm font-medium text-gray-700 mb-2">Status</label>
                                <select id="status" name="status" 
                                        class="w-full px-3 py-2 border border-gray-300 rounded-none focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    <option value="">Semua Status</option>
                                    <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                                    <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                                </select>
                            </div>
                            
                            <!-- Action Buttons -->
                            <div class="flex items-end space-x-2">
                                <button type="submit" 
                                        class="px-4 py-2 bg-[#192D50] text-white rounded-none hover:bg-[#8B8B8B] transition duration-150">
                                    <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                                    </svg>
                                    Cari
                                </button>
                                <a href="{{ route('admin.partners.index') }}" 
                                   class="px-4 py-2 bg-[#8B8B8B] text-white rounded-none hover:bg-[#192D50] transition duration-150">
                                    Reset
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Search Results Info -->
            <div class="flex justify-between items-center mb-6">
                <div>
                    <h3 class="text-lg font-medium text-gray-900">Data Partner</h3>
                    @if(request('search') || request('status'))
                        <div class="mt-2">
                            <p class="text-sm text-gray-600">
                                Menampilkan {{ $partners->count() }} dari {{ $partners->total() }} partner
                                @if(request('search'))
                                    untuk pencarian "{{ request('search') }}"
                                @endif
                                @if(request('status'))
                                    dengan status {{ ucfirst(request('status')) }}
                                @endif
                            </p>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Partners Table -->
            <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-[#192D50]">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Partner
                                </th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Kontak
                                </th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Status
                                </th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Hasil Pemeriksaan
                                </th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Aksi
                                </th>
                            </tr>
                        </thead>
                        <tbody class="bg-[#F6F6F6] divide-y divide-[#CBB4B0]">
                            @forelse($partners as $partner)
                                <tr class="hover:bg-[#192D50] hover:bg-opacity-10">
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="flex items-center">
                                            <div class="flex-shrink-0 h-10 w-10">
                                                <div class="h-10 w-10 rounded-full bg-[#192D50] flex items-center justify-center">
                                                    <svg class="h-5 w-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                                                    </svg>
                                                </div>
                                            </div>
                                            <div class="ml-4">
                                                <div class="text-sm font-medium text-gray-900">{{ $partner->name }}</div>
                                                <div class="text-sm text-gray-500">Kode: {{ $partner->code }}</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm text-gray-900">{{ $partner->contact_person }}</div>
                                        <div class="text-sm text-gray-500">{{ $partner->email }}</div>
                                        <div class="text-sm text-gray-500">{{ $partner->phone }}</div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                            @if($partner->status == 'active') bg-[#8B8B8B] text-white
                                            @else bg-[#192D50] text-white @endif">
                                            {{ ucfirst($partner->status) }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        {{ $partner->exam_results_count }} hasil
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                        <div class="flex items-center space-x-2">
                                            <a href="{{ route('admin.partners.show', $partner) }}" 
                                               class="text-[#CBB4B0] hover:text-[#8B8B8B]">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                                </svg>
                                            </a>
                                            <a href="{{ route('admin.partners.edit', $partner) }}" 
                                               class="text-[#8B8B8B] hover:text-[#CBB4B0]">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                                                </svg>
                                            </a>
                                            <form method="POST" action="{{ route('admin.partners.toggle-status', $partner) }}" class="inline">
                                                @csrf
                                                <button type="submit" 
                                                        class="text-[#8B8B8B] hover:text-[#CBB4B0]"
                                                        onclick="return confirm('Yakin ingin mengubah status partner ini?')">
                                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4"></path>
                                                    </svg>
                                                </button>
                                            </form>
                                            <form method="POST" action="{{ route('admin.partners.destroy', $partner) }}" class="inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" 
                                                        class="text-[#CBB4B0] hover:text-[#8B8B8B]"
                                                        onclick="return confirm('Yakin ingin menghapus partner ini?')">
                                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                                    </svg>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="px-6 py-4 text-center text-gray-500">
                                        Tidak ada partner yang ditemukan.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Pagination -->
            @if($partners->hasPages())
                <div class="mt-6">
                    {{ $partners->links() }}
                </div>
            @endif
        </div>
    </div>
@endsection
